<?php
namespace MajorMedia\Project\Models;

use Model;
use October\Rain\Database\Traits\Validation;
use System\Models\File;
use MajorMedia\ToolBox\Traits\ModelAliases;
use MajorMedia\Project\Traits\EstimateProjectCost;
/**
 * Model
 */
class Quote extends Model
{
    use Validation, ModelAliases, EstimateProjectCost;


    const LABEL_STATUS_1 = 'Brouillon';
    const LABEL_STATUS_2 = 'Envoyé';


    public $table = 'majormedia_project_quotes';

    public $rules = [
    ];
    protected $casts = [
        'is_logo_required' => 'boolean',
        'is_multi_lang' => 'boolean',
        'is_content_required' => 'boolean',
        'languages' => 'array',
    ];
    protected $jsonable = [
        'languages',
        'social_platforms',
    ];

    protected $appends = [
        'quoteUrl',
        'statusAlias',
    ];

    protected $fillable = [
        'id',
        'project_id',
        'quote_date',
        'client_name',
        'reference',
        'recomanded_amount',
        'final_amount',
        'notes',
    ];
    protected $visible = [
        'id',
        'project_id',
        'quote_date',
        'client_name',
        'reference',
        'recomanded_amount',
        'final_amount',
        'statusAlias',
        'quoteUrl',
        'quote'
    ];

    public $belongsTo = [
        'project' => [
            Project::class
        ],
        'environment' => [
            Environment::class
        ],
        'front_design' => [
            FrontDesign::class
        ]
    ];

    public $attachOne = [
        'quote' => File::class,
    ];
    public function getQuoteUrlAttribute()
    {
        try {
            return $this->quote ? $this->quote->path : null;
        } catch (\Exception $e) {
            \Log::error('Error retrieving logo URL: ' . $e->getMessage());
            return null;
        }
    }

    public function getStatusOptions()
    {
        return $this->guessOptions('LABEL_STATUS_');
    }

    public function getStatusAliasAttribute()
    {
        $options = $this->getStatusOptions();
        return (isset($options[$this->status]) ? $options[$this->status] : '-');
    }

    // public function afterCreate()
    // {
    //     $recomanded_amount = 0;
    //     $basic_pages = $this->project->sitemapPages()->wherePrimary(1);
    //     $extras_pages = $this->project->sitemapPages()->wherePrimary(0);
    //     $extras_features = $this->project->features()->wherePrimary(0);
    //     $custom_features_cost = $this->customFeaturesCost(array_merge($this->project->custom_features, $extras_features));


    //     foreach ($pages as $page) {

    //     }
    // }

}
