<?php
namespace Majormedia\Project\Updates;

use MajorMedia\Project\Models\ProjectType;
use Seeder;
use DB;
use Log;

/**
 * CreateProjectTypeSeeder Seeder
 *
 * Seeds project types into the database.
 */
class CreateProjectFrontDesignsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $frontDesigns = [
            ['name' => 'Base de thème'],
            ['name' => 'Design sur mesure']
        ];

        DB::table('majormedia_project_front_designs')->insert($frontDesigns);

        // seed pivot table with project type 

        $frontDesignsToProjectType = [
            'E-commerce' => [
                'Base de thème' => 2000.000000,
                'Design sur mesure' => 3000.000000,
            ],
            'Vitrine' => [
                'Base de thème' => 1200.000000,
                'Design sur mesure' => 2500.000000,
            ],
            'Landing page' => [
                'Base de thème' => 800.000000,
                'Design sur mesure' => 1000.000000,
            ],
        ];


        foreach ($frontDesignsToProjectType as $projectType => $designs) {
            // Get project type ID
            $projectTypeId = ProjectType::where('name', $projectType)->value('id');

            // Log the project type ID for reference
            Log::info("Processing project type: {$projectType} with ID: {$projectTypeId}");

            foreach ($designs as $design => $price) {
                // Get design ID
                $designId = DB::table('majormedia_project_front_designs')->where('name', $design)->value('id');

                // Log the design name and price for reference
                Log::info("Processing design: {$design} with ID: {$designId} and price: {$price}");

                // Insert the record into the pivot table
                DB::table('majormedia_project_type_designs')->insert(
                    [
                        'project_type_id' => $projectTypeId,
                        'front_design_id' => $designId,
                        'initial_price' => $price,
                    ]
                );
                //overview
                

                // Log the successful insertion
                Log::info("Inserted front design '{$design}' (ID: {$designId}) for project type '{$projectType}' (ID: {$projectTypeId}) with initial price: {$price}");
            }
        }


        // Ecommerce - Base de theme : 2000
        // Ecommerce - Design sur mesure : 3000


        // Vitrine - Base de theme : 1200
        // Vitrine - Design sur mesure : 2500

        // Landing page - Base de theme : 800
        // Landing page - Design sur mesure : 1000
    }
}
