@extends('majormedia.project::quote.app')
@section('content')

@php
    $formattedDate = \Carbon\Carbon::parse($quote->quote_date)->format('d/m/Y');
@endphp

<!-- Client Info Section -->
<section class="py-6 flex justify-end">
    <div class="grid grid-cols-2 gap-x-6 gap-y-1.5 text-sm">
        <span class="font-bold text-primary text-right">Client:</span>
        <span class="font-bold text-gray-900">{{ $quote->client_name }}</span>
        <span class="font-bold text-primary text-right">Téléphone:</span>
        <span class="font-bold text-gray-900">{{ $project->user->phone ?? '+212 X XX XX XX XX' }}</span>
        <span class="font-bold text-primary text-right">Date:</span>
        <span class="font-bold text-gray-900">{{ $formattedDate }}</span>
    </div>
</section>

<!-- Project Title -->
<div class="bg-accent py-3 px-6 rounded mb-6">
    <h2 class="text-primary font-extrabold text-base uppercase leading-tight">
        Développement d'un site {{ $project->project_type->name }} : {{ $project->title ?? $quote->client_name }}
    </h2>
</div>

<!-- Main Table -->
<div class="border-2 border-primary rounded overflow-hidden mb-6">
    <table class="w-full text-left border-collapse">
        <thead class="bg-primary text-white">
            <tr>
                <th class="py-2.5 px-4 w-10 text-center font-bold text-sm">N°</th>
                <th class="py-2.5 px-5 font-bold text-sm">DESIGNATION</th>
                <th class="py-2.5 px-5 w-32 text-right font-bold text-sm">PRIX</th>
            </tr>
        </thead>
        <tbody class="text-gray-800 bg-white">
            <tr>
                <td class="py-5 px-4 align-top text-center border-r border-primary font-bold text-lg text-primary">
                    1
                </td>
                <td class="py-5 px-5 align-top border-r border-primary">
                    <div class="space-y-4">
                        <!-- Main Title -->
                        <h3 class="text-primary font-extrabold text-base leading-tight">
                            1. Développement d'un site {{ $project->project_type->name }} : {{ $project->title ?? $quote->client_name }}
                        </h3>

                        <!-- Section 1.1 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">1.1 Installation et configuration du CMS {{ $cms_name }}</h4>
                            <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                <li class="list-bullet">Installation complète de {{ $cms_name }} sur l'hébergement du client.</li>
                                <li class="list-bullet">Installation et personnalisation d'un thème premium adapté au secteur {{ $project->project_type->name }}.</li>
                                <li class="list-bullet">Configuration générale du site en langue {{ is_array($project->languages) ? implode(', ', $project->languages) : $project->languages }}.</li>
                                <li class="list-bullet">Intégration du contenu fourni : textes, images, logo, photos.</li>
                            </ul>
                        </div>

                        <!-- Section 1.2 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">1.2 Design et intégration</h4>
                            <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                <li class="list-bullet">Personnalisation visuelle (charte graphique, couleurs, typographies) en cohérence avec l'identité - {{ $front_design->name }}.</li>
                                <li class="list-bullet">Création et intégration des pages / sections suivantes :
                                    <ul class="list-none pl-5 mt-1 space-y-1 italic text-xs">
                                        @foreach ($pagesGrouped as $categoryName => $categoryPages)
                                            <li class="list-bullet">
                                                <strong>{{ $categoryName }} :</strong>
                                                <ul class="list-none pl-5 mt-0.5 space-y-0.5 text-[11px] not-italic text-gray-700">
                                                    @foreach ($categoryPages->unique('id') as $page)
                                                        <li>▪ {{ $page->name }}{{ $page->description ? ' : ' . $page->description : '' }}</li>
                                                    @endforeach
                                                </ul>
                                            </li>
                                        @endforeach
                                    </ul>
                                </li>
                                <li class="list-bullet">Mise en page responsive (ordinateur, tablette, mobile).</li>
                                <li class="list-bullet">Intégration d'un formulaire d'acquisition (Nom, Email, Téléphone, Message).</li>
                                <li class="list-bullet">Wireframe inclus.</li>
                                <li class="list-bullet">Bibliothèque d'images libres de droits incluse (Freepik).</li>
                                <li class="list-bullet">Licence d'icônes FontAwesome incluse.</li>
                                <li class="list-bullet">Installation des systèmes antispam et captchas.</li>
                                <li class="list-bullet">Création de bannières et carrousels (sliders) si nécessaire.</li>
                                <li class="list-bullet">Nombre de retours inclus : 3 allers-retours.</li>
                            </ul>
                        </div>

                        @if(count($features) > 0)
                        <!-- Section 1.3 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">1.3 Fonctionnalités spécifiques</h4>
                            <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                @foreach ($features as $feature)
                                    <li class="list-bullet">{{ $feature->title }}{{ $feature->description ? ' : ' . $feature->description : '' }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif

                        <!-- Section 2 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">2. Modules complémentaires</h4>

                            <!-- 2.1 SEO -->
                            <div class="mb-2 ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.1 Optimisations SEO</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    <li class="list-bullet">Création d'une architecture de pages optimisée pour le référencement naturel.</li>
                                    <li class="list-bullet">Intégration d'un plan de site (sitemap) pour un meilleur crawl.</li>
                                    <li class="list-bullet">Installation d'un module d'optimisation générale du site.</li>
                                    <li class="list-bullet">Installation d'un module d'optimisation du poids des images.</li>
                                    <li class="list-bullet">Installation et configuration de Google Analytics, Google Search Console et Google My Business.</li>
                                    <li class="list-bullet">Optimisation du maillage interne.</li>
                                    <li class="list-bullet">Hiérarchisation du contenu.</li>
                                </ul>
                            </div>

                            <!-- 2.2 Marketing -->
                            <div class="mb-2 ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.2 Optimisations marketing</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    @if($project->type_id == 1)
                                        <li class="list-bullet">Mise en avant des appels à l'action (contact, demande de devis, panier).</li>
                                        <li class="list-bullet">Mise en avant des arguments commerciaux et des valeurs de la société.</li>
                                        <li class="list-bullet">Mise en avant des coordonnées téléphoniques.</li>
                                        <li class="list-bullet">Configuration des moyens de paiement en ligne.</li>
                                        <li class="list-bullet">Configuration des modes de livraison.</li>
                                    @else
                                        <li class="list-bullet">Mise en avant des appels à l'action (contact, demande de devis).</li>
                                        <li class="list-bullet">Mise en avant des arguments commerciaux et des valeurs de la société.</li>
                                        <li class="list-bullet">Mise en avant des coordonnées téléphoniques.</li>
                                    @endif
                                </ul>
                            </div>

                            <!-- 2.3 Security -->
                            <div class="mb-2 ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.3 Sécurité et sauvegarde</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    <li class="list-bullet">Installation d'un certificat HTTPS.</li>
                                    <li class="list-bullet">Installation et configuration d'un pare-feu et antivirus.</li>
                                    <li class="list-bullet">Installation d'un système de sauvegarde automatique.</li>
                                    <li class="list-bullet">Mise en place d'un système de cache.</li>
                                </ul>
                            </div>

                            <!-- 2.4 Compatibility -->
                            <div class="ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.4 Compatibilité et administration</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    <li class="list-bullet">Site compatible avec Chrome, Firefox, Safari, Edge et mobile.</li>
                                    <li class="list-bullet">Création des comptes administrateurs et contributeurs.</li>
                                    <li class="list-bullet">Assistance utilisateur pour la prise en main de {{ $cms_name }}.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </td>
                <td class="py-5 px-5 align-top text-right font-black text-xl text-primary">
                    {{ number_format($pricing['total_ht'], 0, '', ' ') }} DHS
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- Pricing Summary -->
<div class="flex justify-end mb-6">
    <div class="bg-white border-2 border-primary rounded overflow-hidden shadow-md w-80">
        <div class="grid grid-cols-2">
            <div class="bg-primary text-white px-5 py-2.5 font-bold text-sm">Total HT</div>
            <div class="bg-accent px-5 py-2.5 text-right font-black text-base text-primary">{{ number_format($pricing['total_ht'], 0, '', ' ') }} DHS</div>

            <div class="bg-primary text-white px-5 py-2.5 font-bold text-sm">TVA {{ $pricing['tva_rate'] }}%</div>
            <div class="bg-accent px-5 py-2.5 text-right font-black text-base text-primary">{{ number_format($pricing['tva'], 0, '', ' ') }} DHS</div>

            <div class="bg-primary text-white px-5 py-3 font-bold text-base">Total TTC</div>
            <div class="bg-accent px-5 py-3 text-right font-black text-xl text-primary">{{ number_format($pricing['total_ttc'], 0, '', ' ') }} DHS</div>
        </div>
    </div>
</div>

<!-- Payment Terms -->
<div class="mb-4">
    <p class="text-primary font-bold text-base leading-tight">
        Arrêté le présent devis sous le montant de {{ number_format($pricing['total_ttc'], 0, '', ' ') }} DHS TTC
    </p>
</div>

<div class="mb-5">
    <p class="text-gray-800 font-semibold text-sm">
        <span class="text-primary font-bold">Modalité de paiement :</span> 50%-25%-25%
    </p>
</div>

<!-- Payment Information -->
<div class="bg-gray-50 border-l-4 border-primary p-5 rounded mb-6">
    <h3 class="font-bold text-primary mb-2.5 text-sm">Informations de paiement :</h3>
    <p class="text-xs mb-1.5 leading-relaxed"><strong class="text-gray-900">Bank Name:</strong> <span class="text-gray-700">{{ $company['bank_name'] }}</span></p>
    <p class="text-xs mb-1.5 leading-relaxed"><strong class="text-gray-900">Titulaire du compte :</strong> <span class="text-gray-700">{{ $company['bank_account'] }}</span></p>
    <p class="text-xs leading-relaxed"><strong class="text-gray-900">RIB :</strong> <span class="text-gray-700">{{ $company['rib'] }}</span></p>
</div>

@endsection
