<?php
namespace Majormedia\Reference\Http;

use Backend\Classes\Controller;
use MajorMedia\Reference\Models\Category;
use MajorMedia\Reference\Models\Industry;
use MajorMedia\Reference\Models\PrestationType;
use MajorMedia\ToolBox\Traits\JsonAbort;
use MajorMedia\ToolBox\Traits\RetrieveUser;
use Majormedia\ToolBox\Traits\GetFileFromBase64;
use MajorMedia\ToolBox\Traits\GetValidatedInput;
use MajorMedia\ToolBox\Utility\ErrorCodes;
/**
 * References Back-end Controller
 */
class References extends Controller
{
    use RetrieveUser, GetValidatedInput, JsonAbort, GetFileFromBase64;
    public $implement = [
        'MajorMedia.ToolBox.Behaviors.RestController'
    ];

    public $restConfig = 'config_rest.yaml';

    public function extendModel($model)
    {
        $model = $model->when(request()->has('industry'), function ($query) {
            $query->whereHas('industry', function ($query) {
                return $query->where('id', request('industry'));
            });
        });

        $model = $model->when(request()->has('prestationType'), function ($query) {
            $query->whereHas('prestationType', function ($query) {
                return $query->where('id', request('prestationType'));
            });
        });
        $model = $model->when(request()->has('category'), function ($query) {
            $query->whereHas('category', function ($query) {
                return $query->where('id', request('category'));
            });
        });
        return $model->orderBy('created_at', 'desc');
    }

    public function getFiltersCriteria()
    {
        $categories = Category::all();
        $industries = Industry::all();
        $presentationTypes = PrestationType::all();

        return $this->JsonAbort([
            'status' => 'success',
            'data' => [
                'categories' => $categories,
                'industries' => $industries,
                'presentationTypes' => $presentationTypes
            ]
        ], 200);
    }

}
