<?php
namespace MajorMedia\Reference\Models;

use Model;
use MajorMedia\Reference\Models\Category;
use MajorMedia\Reference\Models\Reference;
use October\Rain\Database\Traits\Validation;

/**
 * PrestationType Model
 */
class PrestationType extends Model
{
    use Validation;

    public $table = 'majormedia_reference_prestation_types';

    public $rules = [];

    protected $fillable = ['name'];
    protected $visible = ['id', 'name'];
    public $hasMany = [
        'references' => [Reference::class],
        'categories' => [Category::class]
    ];
}