<?php
namespace MajorMedia\Reference\Models;

use Model;
use MajorMedia\Reference\Models\Category;
use MajorMedia\Reference\Models\Industry;
use October\Rain\Database\Traits\Validation;
use MajorMedia\Reference\Models\PrestationType;
use System\Models\File;

/**
 * References Model
 */
class Reference extends Model
{
    use Validation;

    public $table = 'majormedia_reference_references';

    public $rules = [];

    protected $appends = ['cover_url','images_urls'];
    protected $fillable = ['title', 'description', 'slug', 'url', 'client_name', 'status'];
    protected $visible = ['id', 'title', 'description', 'slug', 'url','cover_url','images_urls','client_name', 'status', 'image_url'];

    public $belongsTo = [
        'industry' => [Industry::class],
        'prestationType' => [PrestationType::class,'key'=>'prestation_id'],
        'category' => [Category::class]
    ];

    public $attachOne = [
        'cover' => [File::class],
    ];

    public $attachMany = [
        'images' => [File::class],
    ];

    /**
     * Accessors
     */
    public function getCoverUrlAttribute()
    {
        return $this->cover ? $this->cover->path : null;
    }
    public function getImagesUrlsAttribute()
    {
        $urls = [];
        if ($this->images && $this->images->isNotEmpty()) {
            foreach ($this->images as $image) {
                $urls[] = [
                    'path' => $image->path,
                ];
            }
        }
        if ($this->cover) {
            array_unshift($urls, [
                'path' => $this->cover->path
            ]);
        }
        return $urls;
    }

}