<?php
namespace MajorMedia\Structure\Models;

use Model;
use System\Models\File;
use MajorMedia\Structure\Models\Section;
use MajorMedia\Structure\Models\Category;
use MajorMedia\Project\Models\ProjectType;

/**
 * Model
 */
class Page extends Model
{
    use \October\Rain\Database\Traits\Validation;


    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_structure_pages';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $visible = [
        'id',
        'name',
        'pivot',
        'sections',
        'sitemap_sections',

    ];
    protected $fillable = [
        'name',
    ];
    protected $guarded = ['id'];

    public $belongsTo = [
        'category' => [Category::class, 'key' => 'category_id']
    ];
    public $belongsToMany = [
        'projectTypes' => [
            ProjectType::class,
            'table' => 'majormedia_structure_project_pages',
            'key' => 'page_id',
            'otherKey' => 'project_type_id',
            'pivot' => ['is_required', 'is_primary']
        ],
        'sections' => [
            Section::class,
            'table' => 'majormedia_structure_page_sections',
            'key' => 'page_id',
            'otherKey' => 'section_id',
            'pivot' => ['is_primary', 'is_required', 'order']
        ],
        'sitemap_sections' => [
            Section::class,
            'table' => 'majormedia_structure_sitemaps',
            'key' => 'page_id',
            'otherKey' => 'section_id',
            'pivot' => ['project_id', 'field_id']
        ]
    ];

    public $hasMany = [
        'siteMaps' => [SiteMap::class, 'key' => 'page_id']
    ];


}
