<?php
namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructureFeatures extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_features', function ($table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->unsignedBigInteger('project_id')->nullable()->index('fk_project_id');
            $table->string('title')->nullable()->index('index_title');
            $table->longText('description')->nullable();
            $table->decimal('price', 10, 6)->nullable()->index('index_price');
            $table->boolean('is_intern')->nullable()->index('index_is_intern');
            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');

            $table->foreign('project_id', 'fk_features_project_id')->references('id')->on('majormedia_project_projects')->onDelete('set null')->onUpdate('cascade');
        });
    }

    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_features');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}
