<?php
namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructurefields extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_fields', function ($table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->string('name')->nullable()->index('index_name');
            $table->string('type')->nullable()->index('index_type');
            $table->integer('char_from')->nullable()->index('index_char_from');
            $table->integer('char_to')->nullable()->index('index_char_to');
            $table->integer('order')->default(1)->index('index_order');
            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
        });
    }

    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_fields');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}
