<?php
namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructurePageSection extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_page_sections', function ($table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->unsignedBigInteger('page_id')->index('fk_page_id');
            $table->unsignedBigInteger('section_id')->index('fk_section_id');
            $table->unsignedBigInteger('project_type_id')->nullable()->index('fk_project_type_id');

            $table->boolean('is_required')->default(0)->index('index_is_required');
            $table->boolean('is_primary')->default(0)->index('index_is_primary');
            $table->boolean('is_repeater')->default(0)->index('index_is_repeater');
            $table->integer('order')->default(0)->index('index_order');

            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');

            $table->foreign('page_id', 'fk_section_page_id')->references('id')->on('majormedia_structure_pages')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('section_id', 'fk_page_section_id')->references('id')->on('majormedia_structure_sections')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('project_type_id', 'fk_section_project_type_id')->references('id')->on('majormedia_project_project_types')->onDelete('CASCADE')->onUpdate('CASCADE');

        });
    }

    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_page_sections');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}