<?php
namespace Majormedia\Structure\Updates;

use DB;
use Seeder;
use MajorMedia\Structure\Models\Page;
use MajorMedia\Structure\Models\Section;
use MajorMedia\Structure\Models\Category;

/**
 * CreateSectionsSeeder Seeder
 *
 * Seeds predefined sections into the database.
 */
class CreateCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $categories = [
            ['name' => 'Classique'],
            ['name' => 'Ecommerce'],
            ['name' => 'Légale'],
            ['name' => 'Espace client'],
            ['name' => 'Contact']
        ];


        // Insert the section data into the table
        DB::table('majormedia_structure_page_categories')->insert($categories);

        $pagesToCategories = [
            'Classique' => [
                'Accueil',
                'Services',
                'À propos',
                'Blog',
                'Projets',
                'Partenaires',
                'FAQ',
            ],
            'Ecommerce' => [
                'Boutique',
                'Fiche de produit',
                'Catégories',
                'Collection',
                'Panier',
                'Tunnel de commande',
                'Promotions',
                'Wishlist'
            ],
            'Espace client' => [
                'Espace client'
            ],
            'Légale' => [
                'Conditions générales de vente',
                'Politique de retour',
                'Mentions légales',
                'Politique de confidentialité',
            ],
            'Contact' => [
                'Contact',
            ]
        ];

        //link pages to categories
        foreach ($pagesToCategories as $category => $pages) {
            $category = Category::where('name', $category)->first();
            foreach ($pages as $page) {
                $page = Page::where('name', $page)->first();
                $page->category_id = $category->id;
                $page->save();
            }
        }
    }
}
