<?php
namespace Majormedia\Structure\Updates;

use Seeder;
use Illuminate\Support\Facades\DB;
use Majormedia\Structure\Models\Field;
use Majormedia\Structure\Models\Section;

/**
 * CreateFieldsSeeder Seeder
 *
 * Seeds predefined fields into the database and links them to sections.
 */
class CreateFieldsSeeder extends Seeder
{
    public function run()
    {
        // ============================================
        // FIELDS DEFINITIONS
        // ============================================
        $fields = [
            // Textes de base
            ['name' => 'Titre', 'type' => 'text', 'order' => 1, 'char_from' => 30, 'char_to' => 100],
            ['name' => 'Sous-titre', 'type' => 'text', 'order' => 2, 'char_from' => 50, 'char_to' => 150],
            ['name' => 'Description', 'type' => 'text_area', 'order' => 3, 'char_from' => 100, 'char_to' => 500],
            ['name' => 'Description courte', 'type' => 'text_area', 'order' => 4, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Contenu', 'type' => 'rich_text', 'order' => 5, 'char_from' => 500, 'char_to' => 5000],
            ['name' => 'Texte', 'type' => 'text_area', 'order' => 6, 'char_from' => 100, 'char_to' => 1000],

            // Boutons et CTA
            ['name' => 'Bouton d\'action', 'type' => 'text', 'order' => 10, 'char_from' => 10, 'char_to' => 40],
            ['name' => 'Bouton secondaire', 'type' => 'text', 'order' => 11, 'char_from' => 10, 'char_to' => 40],
            ['name' => 'Lien', 'type' => 'url', 'order' => 12, 'char_from' => null, 'char_to' => null],
            ['name' => 'Lien secondaire', 'type' => 'url', 'order' => 13, 'char_from' => null, 'char_to' => null],

            // Médias
            ['name' => 'Image', 'type' => 'file_upload', 'order' => 20, 'char_from' => null, 'char_to' => null],
            ['name' => 'Image de fond', 'type' => 'file_upload', 'order' => 21, 'char_from' => null, 'char_to' => null],
            ['name' => 'Galerie d\'images', 'type' => 'file_upload_multiple', 'order' => 22, 'char_from' => null, 'char_to' => null],
            ['name' => 'Vidéo', 'type' => 'url', 'order' => 23, 'char_from' => null, 'char_to' => null],
            ['name' => 'Logo', 'type' => 'file_upload', 'order' => 24, 'char_from' => null, 'char_to' => null],
            ['name' => 'Icône', 'type' => 'file_upload', 'order' => 25, 'char_from' => null, 'char_to' => null],
            ['name' => 'Fichier PDF', 'type' => 'file_upload', 'order' => 26, 'char_from' => null, 'char_to' => null],

            // Éléments répétables
            ['name' => 'Élément de liste', 'type' => 'repeater', 'order' => 30, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Caractéristique', 'type' => 'repeater', 'order' => 31, 'char_from' => 30, 'char_to' => 150],
            ['name' => 'Avantage', 'type' => 'repeater', 'order' => 32, 'char_from' => 30, 'char_to' => 150],
            ['name' => 'Étape', 'type' => 'repeater', 'order' => 33, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Témoignage', 'type' => 'repeater', 'order' => 34, 'char_from' => 100, 'char_to' => 300],
            ['name' => 'Question/Réponse', 'type' => 'repeater', 'order' => 35, 'char_from' => 100, 'char_to' => 500],
            ['name' => 'Service', 'type' => 'repeater', 'order' => 36, 'char_from' => 100, 'char_to' => 400],
            ['name' => 'Membre d\'équipe', 'type' => 'repeater', 'order' => 37, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Partenaire', 'type' => 'repeater', 'order' => 38, 'char_from' => 20, 'char_to' => 100],
            ['name' => 'Chiffre clé', 'type' => 'repeater', 'order' => 39, 'char_from' => 20, 'char_to' => 80],
            ['name' => 'Événement', 'type' => 'repeater', 'order' => 40, 'char_from' => 100, 'char_to' => 300],
            ['name' => 'Tarif', 'type' => 'repeater', 'order' => 41, 'char_from' => 100, 'char_to' => 400],
            ['name' => 'Projet', 'type' => 'repeater', 'order' => 42, 'char_from' => 100, 'char_to' => 300],
            ['name' => 'Article', 'type' => 'repeater', 'order' => 43, 'char_from' => 100, 'char_to' => 300],
            ['name' => 'Produit', 'type' => 'repeater', 'order' => 44, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Catégorie', 'type' => 'repeater', 'order' => 45, 'char_from' => 30, 'char_to' => 100],
            ['name' => 'Marque', 'type' => 'repeater', 'order' => 46, 'char_from' => 20, 'char_to' => 80],
            ['name' => 'Avis client', 'type' => 'repeater', 'order' => 47, 'char_from' => 100, 'char_to' => 400],
            ['name' => 'Offre d\'emploi', 'type' => 'repeater', 'order' => 48, 'char_from' => 100, 'char_to' => 500],
            ['name' => 'Lien de menu', 'type' => 'repeater', 'order' => 49, 'char_from' => 20, 'char_to' => 60],
            ['name' => 'Réseau social', 'type' => 'repeater', 'order' => 50, 'char_from' => null, 'char_to' => null],
            ['name' => 'Garantie', 'type' => 'repeater', 'order' => 51, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Bonus', 'type' => 'repeater', 'order' => 52, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Option de filtre', 'type' => 'repeater', 'order' => 53, 'char_from' => 20, 'char_to' => 80],
            ['name' => 'Méthode de paiement', 'type' => 'repeater', 'order' => 54, 'char_from' => 30, 'char_to' => 100],
            ['name' => 'Option de livraison', 'type' => 'repeater', 'order' => 55, 'char_from' => 50, 'char_to' => 150],
            ['name' => 'Élément de réassurance', 'type' => 'repeater', 'order' => 56, 'char_from' => 30, 'char_to' => 100],

            // Formulaires
            ['name' => 'Champ email', 'type' => 'email', 'order' => 60, 'char_from' => null, 'char_to' => null],
            ['name' => 'Champ téléphone', 'type' => 'text', 'order' => 61, 'char_from' => null, 'char_to' => null],
            ['name' => 'Champ nom', 'type' => 'text', 'order' => 62, 'char_from' => null, 'char_to' => null],
            ['name' => 'Champ message', 'type' => 'text_area', 'order' => 63, 'char_from' => null, 'char_to' => null],
            ['name' => 'Champ fichier', 'type' => 'file_upload', 'order' => 64, 'char_from' => null, 'char_to' => null],
            ['name' => 'Placeholder', 'type' => 'text', 'order' => 65, 'char_from' => 20, 'char_to' => 60],
            ['name' => 'Label', 'type' => 'text', 'order' => 66, 'char_from' => 10, 'char_to' => 40],

            // Contact et localisation
            ['name' => 'Adresse', 'type' => 'text_area', 'order' => 70, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Téléphone', 'type' => 'text', 'order' => 71, 'char_from' => 10, 'char_to' => 20],
            ['name' => 'Email', 'type' => 'text', 'order' => 72, 'char_from' => 20, 'char_to' => 50],
            ['name' => 'Horaires', 'type' => 'text_area', 'order' => 73, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Coordonnées GPS', 'type' => 'text', 'order' => 74, 'char_from' => null, 'char_to' => null],

            // Éléments spécifiques
            ['name' => 'Prix', 'type' => 'text', 'order' => 80, 'char_from' => 5, 'char_to' => 20],
            ['name' => 'Ancien prix', 'type' => 'text', 'order' => 81, 'char_from' => 5, 'char_to' => 20],
            ['name' => 'Badge/Label', 'type' => 'text', 'order' => 82, 'char_from' => 5, 'char_to' => 30],
            ['name' => 'Note/Étoiles', 'type' => 'number', 'order' => 83, 'char_from' => null, 'char_to' => null],
            ['name' => 'Nombre', 'type' => 'number', 'order' => 84, 'char_from' => null, 'char_to' => null],
            ['name' => 'Pourcentage', 'type' => 'text', 'order' => 85, 'char_from' => 2, 'char_to' => 5],
            ['name' => 'Date', 'type' => 'date', 'order' => 86, 'char_from' => null, 'char_to' => null],
            ['name' => 'Durée', 'type' => 'text', 'order' => 87, 'char_from' => 10, 'char_to' => 30],
            ['name' => 'Compte à rebours', 'type' => 'datetime', 'order' => 88, 'char_from' => null, 'char_to' => null],
            ['name' => 'Nom de l\'auteur', 'type' => 'text', 'order' => 89, 'char_from' => 20, 'char_to' => 60],
            ['name' => 'Poste/Fonction', 'type' => 'text', 'order' => 90, 'char_from' => 20, 'char_to' => 80],
            ['name' => 'Entreprise', 'type' => 'text', 'order' => 91, 'char_from' => 20, 'char_to' => 80],
            ['name' => 'Numéro WhatsApp', 'type' => 'text', 'order' => 92, 'char_from' => 10, 'char_to' => 20],
            ['name' => 'Code promo', 'type' => 'text', 'order' => 93, 'char_from' => 5, 'char_to' => 20],
            ['name' => 'SKU/Référence', 'type' => 'text', 'order' => 94, 'char_from' => 5, 'char_to' => 30],
            ['name' => 'Copyright', 'type' => 'text', 'order' => 95, 'char_from' => 30, 'char_to' => 100],
            ['name' => 'Mention légale', 'type' => 'text', 'order' => 96, 'char_from' => 50, 'char_to' => 200],
        ];

        // Insert fields into the database
        foreach ($fields as $field) {
            Field::firstOrCreate(['name' => $field['name']], $field);
        }

        // ============================================
        // FIELDS TO SECTIONS MAPPING
        // ============================================
        $fieldsToSections = [
            // ==========================================
            // SECTIONS GÉNÉRALES
            // ==========================================
            'Héro' => [
                'Titre',
                'Sous-titre',
                'Description courte',
                'Bouton d\'action',
                'Bouton secondaire',
                'Image',
                'Image de fond',
                'Vidéo',
            ],
            'À propos' => [
                'Titre',
                'Sous-titre',
                'Description',
                'Bouton d\'action',
                'Image',
                'Chiffre clé',
            ],
            'Services' => [
                'Titre',
                'Sous-titre',
                'Description courte',
                'Service',
                'Bouton d\'action',
            ],
            'Produits' => [
                'Titre',
                'Sous-titre',
                'Produit',
                'Bouton d\'action',
            ],
            'Témoignages' => [
                'Titre',
                'Sous-titre',
                'Témoignage',
            ],
            'Partenaires (logos)' => [
                'Titre',
                'Partenaire',
            ],
            'Articles' => [
                'Titre',
                'Sous-titre',
                'Article',
                'Bouton d\'action',
            ],
            'Demande de devis' => [
                'Titre',
                'Description courte',
                'Champ nom',
                'Champ email',
                'Champ téléphone',
                'Champ message',
                'Bouton d\'action',
            ],
            'Newsletter' => [
                'Titre',
                'Description courte',
                'Placeholder',
                'Bouton d\'action',
            ],
            'Pied de page' => [
                'Logo',
                'Description courte',
                'Lien de menu',
                'Adresse',
                'Téléphone',
                'Email',
                'Réseau social',
                'Copyright',
            ],
            'Introduction' => [
                'Titre',
                'Description',
                'Image',
            ],
            'Histoire de l\'entreprise' => [
                'Titre',
                'Contenu',
                'Événement',
                'Galerie d\'images',
            ],
            'Mission et vision' => [
                'Titre',
                'Description',
                'Élément de liste',
            ],
            'Valeurs fondamentales' => [
                'Titre',
                'Sous-titre',
                'Élément de liste',
            ],
            'Présentation de l\'équipe' => [
                'Titre',
                'Sous-titre',
                'Membre d\'équipe',
            ],
            'Chronologie ou jalons importants' => [
                'Titre',
                'Événement',
            ],
            'Foire aux questions' => [
                'Titre',
                'Sous-titre',
                'Question/Réponse',
            ],
            'Réassurance' => [
                'Élément de réassurance',
            ],

            // ==========================================
            // SECTIONS E-COMMERCE
            // Note: Les sections produits/catégories/marques n'ont pas de champs
            // car le client remplit un fichier Excel fourni pour l'import
            // ==========================================
            'Nouveautés' => [
                'Titre',
                'Sous-titre',
                'Bouton d\'action',
                // Produits importés via Excel
            ],
            'Produits en vedette' => [
                'Titre',
                'Sous-titre',
                'Bouton d\'action',
                // Produits importés via Excel
            ],
            'Bannière' => [
                'Titre',
                'Sous-titre',
                'Description courte',
                'Bouton d\'action',
                'Image de fond',
                'Badge/Label',
            ],
            'Produits en promotion' => [
                'Titre',
                'Sous-titre',
                'Compte à rebours',
                'Bouton d\'action',
                // Produits importés via Excel
            ],
            'Meilleures ventes' => [
                'Titre',
                'Sous-titre',
                'Bouton d\'action',
                // Produits importés via Excel
            ],
            'Méga menu' => [
                'Lien de menu',
                'Image',
                // Catégories importées via Excel
            ],
            'Bannière de promotion pour les produits en réduction' => [
                'Titre',
                'Sous-titre',
                'Pourcentage',
                'Bouton d\'action',
                'Image de fond',
                'Compte à rebours',
            ],
            'Bannière de produit' => [
                'Titre',
                'Bouton d\'action',
                'Image',
                'Lien',
            ],
            'Bannière de catégorie' => [
                'Titre',
                'Bouton d\'action',
                'Image',
                'Lien',
            ],
            'Bannière de marque' => [
                'Titre',
                'Bouton d\'action',
                'Image',
                'Lien',
            ],
            'Bannières doubles' => [
                'Titre',
                'Bouton d\'action',
                'Image',
                'Lien',
            ],
            'Marques populaires' => [
                'Titre',
                // Marques importées via Excel
            ],
            'Partenaires slider ( logo )' => [
                'Titre',
                'Partenaire',
            ],
            'Flux Instagram' => [
                'Titre',
                'Lien',
            ],
            'Contact via WhatsApp' => [
                'Numéro WhatsApp',
                'Description courte',
            ],
            'Filtres' => [
                'Titre',
                'Option de filtre',
            ],
            'Filtres personnalisés' => [
                'Titre',
                'Option de filtre',
            ],
            'Bannière publicitaire' => [
                'Titre',
                'Description courte',
                'Bouton d\'action',
                'Image',
                'Lien',
            ],
            'Liste / grille de produits' => [
                'Titre',
                // Produits importés via Excel
            ],
            'Détail du produit' => [
                // Tous les champs produit importés via Excel
                // (titre, description, prix, images, SKU, caractéristiques...)
            ],
            'Produits similaires' => [
                'Titre',
                // Produits importés via Excel
            ],
            'Produits associés' => [
                'Titre',
                // Produits importés via Excel
            ],
            'Produits populaires' => [
                'Titre',
                // Produits importés via Excel
            ],
            'Commentaires et avis' => [
                'Titre',
                'Avis client',
            ],
            'Produits récemment consultés' => [
                'Titre',
                // Produits importés via Excel
            ],
            'Boutons de partage sur les réseaux sociaux' => [
                'Réseau social',
            ],
            'Autres informations (Référence - SKU - Nom de la catégorie - Nom de la marque)' => [
                // Données importées via Excel (SKU, catégorie, marque)
            ],
            'Logos de paiement' => [
                'Méthode de paiement',
            ],
            'Produits recommandés' => [
                'Titre',
                // Produits importés via Excel
            ],
            'Partager le panier' => [
                'Titre',
                'Description courte',
            ],
            'Limite de quantité' => [
                'Description courte',
                'Nombre',
            ],
            'panier total prix contrôleur' => [
                'Titre',
                'Prix',
            ],
            'Ajout en temps réel par d\'autres utilisateurs (comme Shopify)' => [
                'Description courte',
            ],
            'Texte personnalisé, Emballage cadeau' => [
                'Titre',
                'Description courte',
                'Champ message',
            ],
            'Informations personnalisées' => [
                'Titre',
                'Champ nom',
                'Champ email',
                'Champ téléphone',
                'Adresse',
            ],
            'Méthodes de paiement' => [
                'Titre',
                'Méthode de paiement',
            ],
            'Catégories de produits' => [
                'Titre',
                // Catégories importées via Excel
            ],
            'Recherche de produits' => [
                'Placeholder',
            ],
            'Comparaison de produits' => [
                'Titre',
                // Produits et caractéristiques importés via Excel
            ],
            'Guide des tailles' => [
                'Titre',
                'Contenu',
                'Image',
            ],
            'Suivi de commande' => [
                'Titre',
                'Description courte',
                'Étape',
            ],
            'Historique des commandes' => [
                'Titre',
            ],
            'Adresses de livraison' => [
                'Titre',
                'Adresse',
            ],
            'Liste de souhaits' => [
                'Titre',
            ],
            'Points de fidélité' => [
                'Titre',
                'Description',
                'Nombre',
            ],
            'Code promo' => [
                'Titre',
                'Placeholder',
                'Bouton d\'action',
            ],
            'Estimation des frais de livraison' => [
                'Titre',
                'Description courte',
            ],
            'Options de livraison' => [
                'Titre',
                'Option de livraison',
            ],
            'Ventes flash' => [
                'Titre',
                'Sous-titre',
                'Compte à rebours',
                'Bouton d\'action',
                // Produits importés via Excel
            ],
            'Compte à rebours promotion' => [
                'Titre',
                'Compte à rebours',
            ],

            // ==========================================
            // SECTIONS VITRINE / CORPORATE
            // ==========================================
            'Nos réalisations' => [
                'Titre',
                'Sous-titre',
                'Projet',
                'Bouton d\'action',
            ],
            'Galerie photos' => [
                'Titre',
                'Galerie d\'images',
            ],
            'Galerie vidéos' => [
                'Titre',
                'Vidéo',
            ],
            'Nos clients' => [
                'Titre',
                'Partenaire',
            ],
            'Chiffres clés' => [
                'Titre',
                'Chiffre clé',
            ],
            'Processus de travail' => [
                'Titre',
                'Sous-titre',
                'Étape',
            ],
            'Tarifs / Offres' => [
                'Titre',
                'Sous-titre',
                'Tarif',
            ],
            'Carte / Localisation' => [
                'Titre',
                'Adresse',
                'Coordonnées GPS',
            ],
            'Formulaire de contact' => [
                'Titre',
                'Description courte',
                'Champ nom',
                'Champ email',
                'Champ téléphone',
                'Champ message',
                'Bouton d\'action',
            ],
            'Informations de contact' => [
                'Titre',
                'Adresse',
                'Téléphone',
                'Email',
                'Réseau social',
            ],
            'Horaires d\'ouverture' => [
                'Titre',
                'Horaires',
            ],
            'Certifications / Récompenses' => [
                'Titre',
                'Élément de liste',
                'Image',
            ],
            'Téléchargements / Ressources' => [
                'Titre',
                'Fichier PDF',
                'Description courte',
            ],
            'Actualités' => [
                'Titre',
                'Sous-titre',
                'Article',
                'Bouton d\'action',
            ],
            'Événements' => [
                'Titre',
                'Événement',
            ],
            'Zones de service' => [
                'Titre',
                'Élément de liste',
            ],
            'Avantages / Pourquoi nous choisir' => [
                'Titre',
                'Sous-titre',
                'Avantage',
            ],
            'Appel à l\'action (CTA)' => [
                'Titre',
                'Sous-titre',
                'Description courte',
                'Bouton d\'action',
                'Bouton secondaire',
                'Image de fond',
            ],
            'Comparatif de services' => [
                'Titre',
                'Service',
                'Caractéristique',
            ],
            'Liens vers réseaux sociaux' => [
                'Réseau social',
            ],
            'Détail du service' => [
                'Titre',
                'Description',
                'Contenu',
                'Image',
                'Galerie d\'images',
                'Caractéristique',
                'Bouton d\'action',
            ],
            'Liste des services' => [
                'Titre',
                'Sous-titre',
                'Service',
            ],
            'Détail du projet' => [
                'Titre',
                'Description',
                'Contenu',
                'Image',
                'Galerie d\'images',
                'Caractéristique',
                'Date',
                'Bouton d\'action',
            ],
            'Liste des projets' => [
                'Titre',
                'Sous-titre',
                'Projet',
            ],
            'Filtres projets' => [
                'Option de filtre',
            ],

            // ==========================================
            // SECTIONS LANDING PAGE
            // ==========================================
            'Héro avec vidéo' => [
                'Titre',
                'Sous-titre',
                'Description courte',
                'Bouton d\'action',
                'Bouton secondaire',
                'Vidéo',
                'Image de fond',
            ],
            'Problème / Solution' => [
                'Titre',
                'Sous-titre',
                'Description',
                'Élément de liste',
                'Image',
            ],
            'Caractéristiques / Fonctionnalités' => [
                'Titre',
                'Sous-titre',
                'Caractéristique',
            ],
            'Preuves sociales' => [
                'Chiffre clé',
                'Partenaire',
            ],
            'Garanties' => [
                'Titre',
                'Garantie',
            ],
            'Offre limitée' => [
                'Titre',
                'Description',
                'Prix',
                'Ancien prix',
                'Compte à rebours',
                'Bouton d\'action',
            ],
            'Formulaire d\'inscription' => [
                'Titre',
                'Description courte',
                'Champ nom',
                'Champ email',
                'Bouton d\'action',
            ],
            'Countdown / Urgence' => [
                'Titre',
                'Description courte',
                'Compte à rebours',
            ],
            'Bonus / Cadeaux' => [
                'Titre',
                'Bonus',
            ],
            'Avant / Après' => [
                'Titre',
                'Description',
                'Image',
            ],
            'Résultats / Études de cas' => [
                'Titre',
                'Description',
                'Chiffre clé',
                'Témoignage',
            ],
            'À qui s\'adresse cette offre' => [
                'Titre',
                'Description',
                'Élément de liste',
            ],
            'Biographie de l\'expert' => [
                'Titre',
                'Nom de l\'auteur',
                'Poste/Fonction',
                'Description',
                'Image',
                'Réseau social',
            ],
            'Programme / Contenu détaillé' => [
                'Titre',
                'Étape',
                'Élément de liste',
            ],
            'Témoignages vidéo' => [
                'Titre',
                'Vidéo',
                'Nom de l\'auteur',
                'Poste/Fonction',
            ],
            'CTA flottant' => [
                'Bouton d\'action',
                'Lien',
            ],
            'Pop-up d\'intention de sortie' => [
                'Titre',
                'Description courte',
                'Bouton d\'action',
                'Image',
            ],
            'Barre de progression' => [
                'Étape',
            ],
            'Chat en direct' => [
                'Titre',
                'Description courte',
            ],

            // ==========================================
            // SECTIONS BLOG
            // ==========================================
            'Liste des articles' => [
                'Titre',
                'Article',
            ],
            'Article en vedette' => [
                'Titre',
                'Description courte',
                'Image',
                'Bouton d\'action',
            ],
            'Catégories du blog' => [
                'Titre',
                'Catégorie',
            ],
            'Contenu de l\'article' => [
                'Titre',
                'Contenu',
                'Image',
                'Date',
            ],
            'Auteur de l\'article' => [
                'Nom de l\'auteur',
                'Description courte',
                'Image',
                'Réseau social',
            ],
            'Articles similaires' => [
                'Titre',
                'Article',
            ],
            'Commentaires blog' => [
                'Titre',
                'Avis client',
            ],
            'Barre de recherche blog' => [
                'Placeholder',
            ],
            'Tags / Mots-clés' => [
                'Titre',
                'Élément de liste',
            ],
            'Archives' => [
                'Titre',
                'Élément de liste',
            ],
            'Articles récents' => [
                'Titre',
                'Article',
            ],
            'Articles populaires' => [
                'Titre',
                'Article',
            ],

            // ==========================================
            // SECTIONS RECRUTEMENT
            // ==========================================
            'Offres d\'emploi' => [
                'Titre',
                'Sous-titre',
                'Offre d\'emploi',
            ],
            'Détail de l\'offre' => [
                'Titre',
                'Description',
                'Contenu',
                'Élément de liste',
                'Bouton d\'action',
            ],
            'Formulaire de candidature' => [
                'Titre',
                'Description courte',
                'Champ nom',
                'Champ email',
                'Champ téléphone',
                'Champ message',
                'Champ fichier',
                'Bouton d\'action',
            ],
            'Avantages employés' => [
                'Titre',
                'Avantage',
            ],
            'Culture d\'entreprise' => [
                'Titre',
                'Description',
                'Galerie d\'images',
                'Élément de liste',
            ],
            'Processus de recrutement' => [
                'Titre',
                'Étape',
            ],

            // ==========================================
            // SECTIONS LÉGALES
            // ==========================================
            'Contenu textuel' => [
                'Titre',
                'Contenu',
            ],
            'Table des matières' => [
                'Titre',
                'Lien de menu',
            ],
            'Dernière mise à jour' => [
                'Date',
                'Description courte',
            ],
        ];

        // ============================================
        // INSERT FIELD-SECTION RELATIONSHIPS
        // ============================================
        foreach ($fieldsToSections as $sectionName => $fieldNames) {
            $section = Section::where('name', $sectionName)->first();

            if ($section) {
                foreach ($fieldNames as $order => $fieldName) {
                    $field = Field::where('name', $fieldName)->first();

                    if ($field) {
                        DB::table('majormedia_structure_section_fields')->insertOrIgnore([
                            'section_id' => $section->id,
                            'field_id' => $field->id,
                        ]);
                    }
                }
            }
        }
    }
}
