<?php
namespace Majormedia\Structure\Updates;

use DB;
use Seeder;
use MajorMedia\Structure\Models\Page;
use MajorMedia\Project\Models\ProjectType;

/**
 * CreatePagesSeeder Seeder
 *
 * Seeds predefined pages into the database.
 */
class CreatePagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Define the pages to be seeded
        $pages = [
            ['name' => 'Accueil'], // Home
            ['name' => 'Services'], // Services
            ['name' => 'Projets'], // Projects
            ['name' => 'A propos'], // About Us
            ['name' => 'Partenaires'], // Partners
            ['name' => 'FAQ'], // FAQ
            ['name' => 'Blog'], // Blog
            ['name' => 'Contact'], // Contact
            ['name' => 'Nous rejoindre'], // Careers

            // E-commerce specific pages
            ['name' => 'Boutique'], // Shop
            ['name' => 'Fiche de produit'], // Product
            ['name' => 'Catégories'], // Categories
            ['name' => 'Collection'], // Collections
            ['name' => 'Panier'], // Cart
            ['name' => 'Tunnel de commande'], // Checkout
            ['name' => 'Espace client'], // My Account
            ['name' => 'Promotions'], // Promotions
            ['name' => 'Wishlist'], // Wishlist

            // Legal pages
            ['name' => 'Conditions générales de vente'], // Terms and Conditions
            ['name' => 'Politique de retour'], // Return Policy
            ['name' => 'Mentions légales'], // Legal Notice
            ['name' => 'Politique de confidentialité'], // Privacy Policy
        ];

        //pages: panier , checkout , espace client, category :set ecommerce is_required in ecommerce

        // Insert the page data into the table
        DB::table('majormedia_structure_pages')->insert($pages);

        //for each projectype , attach the pages that have the name
        //we need to data strucute for this

        $projectTypesToPages = [
            1 => [ // E-commerce
                ['name' => 'Accueil', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Home
                ['name' => 'À propos', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // About Us
                ['name' => 'Services', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0],// Services
                ['name' => 'Partenaires', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Partners
                ['name' => 'FAQ', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // FAQ
                ['name' => 'Blog', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Blog
                ['name' => 'Contact', 'is_required' => 0, 'is_primary' => 1, 'is_default' => 1], // Contact
                ['name' => 'Boutique', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Shop
                ['name' => 'Fiche de produit', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Product
                ['name' => 'Catégories', 'is_required' => 0, 'is_primary' => 1, 'is_default' => 1], // Categories
                ['name' => 'Collection', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 1], // Collection
                ['name' => 'Marques', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 1], // Brands
                ['name' => 'Panier', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Cart
                ['name' => 'Tunnel de commande', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Checkout
                ['name' => 'Wishlist', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Wishlist
                ['name' => 'Espace client', 'is_required' => 0, 'is_primary' => 1, 'is_default' => 1], // Client Space
                ['name' => 'Promotions', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Promotions
                ['name' => 'Conditions générales de vente', 'is_required' => 0, 'is_primary' => 1, 'is_default' => 1], // Terms and Conditions
                ['name' => 'Politique de retour', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Return Policy
                ['name' => 'Mentions légales', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Legal Notice
                ['name' => 'Politique de confidentialité', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Privacy Policy
            ],
            2 => [ // Vitrine
                ['name' => 'Accueil', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Home
                ['name' => 'À propos', 'is_required' => 0, 'is_primary' => 1, 'is_default' => 1], // About Us
                ['name' => 'Boutique', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Shop
                ['name' => 'Services', 'is_required' => 0, 'is_primary' => 1, 'is_default' => 1], // Services
                ['name' => 'Projets', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Projects
                ['name' => 'Partenaires', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Partners
                ['name' => 'FAQ', 'is_required' => 0, 'is_primary' => 0], // FAQ
                ['name' => 'Blog', 'is_required' => 0, 'is_primary' => 1, 'is_default' => 0], // Blog
                ['name' => 'Nous rejoindre', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Careers
                ['name' => 'Contact', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Contact
                ['name' => 'Mentions légales', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Legal Notice
                ['name' => 'Politique de confidentialité', 'is_required' => 0, 'is_primary' => 0, 'is_default' => 0], // Privacy Policy
            ],
            3 => [ // Portfolio
                ['name' => 'Home', 'is_required' => 1, 'is_primary' => 1, 'is_default' => 1], // Example
            ],
        ];

        foreach ($projectTypesToPages as $projectTypeId => $pages) {
            // Get the ProjectType by its ID
            $projectType = ProjectType::find($projectTypeId);

            if ($projectType) {
                foreach ($pages as $pageData) {
                    // Get the page ID by its name
                    $pageToAttach = Page::where('name', $pageData['name'])->value('id');
                    if ($pageToAttach) {
                        // Attach the page with the pivot fields
                        $projectType->pages()->attach([
                            $pageToAttach => [
                                'is_required' => $pageData['is_required'],
                                'is_primary' => $pageData['is_primary'],
                                'is_default' => $pageData['is_default'] ?? 0
                            ],
                        ]);
                    }
                }
            }
        }

    }
}
