<?php namespace Majormedia\ToolBox\Traits;
use Validator;
use MajorMedia\ToolBox\Utility\ErrorCodes;

trait ValidateOrFail{
	use JsonAbort;

	public function validateOrFail(Array $data, Array $rules=[], Array $errorCodes=[], $statusCode=400){
		if(count($errorCodes) === 0)
			$errorCodes = $this->__validateOrFailValidationErrors;

		$validator = Validator::make($data, $rules, $errorCodes);

        if($validator->fails())
            $this->JsonAbort(
				[
					'status' => 'error',
					// extract the first error code from the array and default to 'unexpected' on error
					'code' => array_values($validator->errors()->toArray())[0][0] ?? ErrorCodes::INVALID_INPUT, // get first error code
				],
            $statusCode);

        return $data;
	}

	// error codes per error
	public $__validateOrFailValidationErrors = [
        'email.required' => ErrorCodes::EMAIL_REQUIRED,
        'email.between' => ErrorCodes::EMAIL_INVALID,
        'email.unique' => ErrorCodes::EMAIL_ALREADY_IN_USE,
        'password.required' => ErrorCodes::PASSWORD_REQUIRED,
        'password.between' => ErrorCodes::PASSWORD_INVALID,
        'password_confirmation.required' => ErrorCodes::PASSWORD_CONFIRMATION_REQUIRED,
        'password_confirmation.between' => ErrorCodes::PASSWORD_CONFIRMATION_INVALID,
        'role_id.required' => ErrorCodes::ROLE_ID_REQUIRED,
        'role_id.in' => ErrorCodes::ROLE_ID_INVALID,
        'email.email' => ErrorCodes::EMAIL_INVALID,
        'avatar.image' => ErrorCodes::AVATAR_INVALID,
        'avatar.max' => ErrorCodes::AVATAR_SIZE_EXCEEDED,
        'username.required' => ErrorCodes::USERNAME_REQUIRED,
        'username.between' => ErrorCodes::USERNAME_INVALID,
        'username.unique' => ErrorCodes::USERNAME_ALREADY_IN_USE,
        'password.confirmed' => ErrorCodes::PASSWORD_CONFIRMATION_MISMATCH,
        'password_confirmation.required_with' => ErrorCodes::PASSWORD_CONFIRMATION_REQUIRED,
        'password_confirmation.between' => ErrorCodes::PASSWORD_CONFIRMATION_INVALID,
        'name.required' => ErrorCodes::NAME_REQUIRED,
        'surname.required' => ErrorCodes::SURNAME_REQUIRED,
        'birthday.required' => ErrorCodes::BIRTHDAY_REQUIRED,
        'gender.required' => ErrorCodes::GENDER_REQUIRED,
        'gender.in' => ErrorCodes::GENDER_INVALID,
        'login.required' => ErrorCodes::LOGIN_REQUIRED,
        'login.exists' => ErrorCodes::LOGIN_NOT_FOUND,
        'otp.required' => ErrorCodes::OTP_REQUIRED,
        'otp.integer' => ErrorCodes::OTP_INVALID,
        'otp.min' => ErrorCodes::OTP_TOO_SHORT,
        'otp.max' => ErrorCodes::OTP_TOO_LONG,
        'username.string' => ErrorCodes::USERNAME_INVALID,
        'surname.string' => ErrorCodes::SURNAME_INVALID,
        'description.string' => ErrorCodes::DESCRIPTION_INVALID,
        'name.string' => ErrorCodes::NAME_INVALID,
        'phone.regex' => ErrorCodes::PHONE_INVALID,
        'weight.numeric' => ErrorCodes::WEIGHT_INVALID,
        'weight.min' => ErrorCodes::WEIGHT_TOO_LOW,
        'height.numeric' => ErrorCodes::HEIGHT_INVALID,
        'height.min' => ErrorCodes::HEIGHT_TOO_LOW,
        'height.max' => ErrorCodes::HEIGHT_TOO_HIGH,
        'weight.max' => ErrorCodes::WEIGHT_TOO_HIGH,
        'status.string' => ErrorCodes::STATUS_INVALID,
        'siren.regex' => ErrorCodes::SIREN_INVALID,
        'siret.regex' => ErrorCodes::SIRET_INVALID,
        'tva.boolean' => ErrorCodes::TVA_INVALID,
        'sap.boolean' => ErrorCodes::SAP_INVALID,
        'mail_notifications.boolean' => ErrorCodes::MAIL_NOTIFICATIONS_INVALID,
        'gender.integer' => ErrorCodes::GENDER_INVALID,
        'birthday.integer' => ErrorCodes::BIRTHDAY_INVALID,
        'birthday.max' => ErrorCodes::BIRTHDAY_TOO_HIGH,
        'birthday.min' => ErrorCodes::BIRTHDAY_TOO_LOW,
        'pro_card_expiry_date.integer' => ErrorCodes::PRO_CARD_EXPIRY_DATE_INVALID,
        'pro_card_expiry_date.min' => ErrorCodes::PRO_CARD_EXPIRY_DATE_TOO_LOW,
        'current_password.required' => ErrorCodes::CURRENT_PASSWORD_REQUIRED,
        'current_password.between' => ErrorCodes::CURRENT_PASSWORD_INVALID,
        'new_password.required' => ErrorCodes::NEW_PASSWORD_REQUIRED,
        'new_password.between' => ErrorCodes::NEW_PASSWORD_INVALID,
        'new_password_confirmation.required' => ErrorCodes::NEW_PASSWORD_CONFIRMATION_REQUIRED,
        'new_password_confirmation.between' => ErrorCodes::NEW_PASSWORD_CONFIRMATION_INVALID,
        'phone.required' => ErrorCodes::PHONE_REQUIRED,
        'phone.string' => ErrorCodes::PHONE_INVALID,
        'age.required' => ErrorCodes::AGE_REQUIRED,
        'age.integer' => ErrorCodes::AGE_INVALID,
        'age.min' => ErrorCodes::AGE_TOO_LOW,
        'age.max' => ErrorCodes::AGE_TOO_HIGH,
        'height.required' => ErrorCodes::HEIGHT_REQUIRED,
        'weight.required' => ErrorCodes::WEIGHT_REQUIRED,
        'is_smoker.required' => ErrorCodes::IS_SMOKER_REQUIRED,
        'is_smoker.boolean' => ErrorCodes::IS_SMOKER_INVALID,
        'alcohol_consumption.required' => ErrorCodes::ALCOHOL_CONSUMPTION_REQUIRED,
        'alcohol_consumption.integer' => ErrorCodes::ALCOHOL_CONSUMPTION_INVALID,
        'alcohol_consumption.in' => ErrorCodes::ALCOHOL_CONSUMPTION_INVALID,
        'tiredness.required' => ErrorCodes::TIREDNESS_REQUIRED,
        'tiredness.integer' => ErrorCodes::TIREDNESS_INVALID,
        'tiredness.in' => ErrorCodes::TIREDNESS_INVALID,
        'physical_level.required' => ErrorCodes::PHYSICAL_LEVEL_REQUIRED,
        'physical_level.integer' => ErrorCodes::PHYSICAL_LEVEL_INVALID,
        'physical_level.in' => ErrorCodes::PHYSICAL_LEVEL_INVALID,
        'goal.required' => ErrorCodes::GOAL_REQUIRED,
        'goal.integer' => ErrorCodes::GOAL_INVALID,
        'goal.in' => ErrorCodes::GOAL_INVALID,
        'period.required' => ErrorCodes::PERIOD_REQUIRED,
        'period.integer' => ErrorCodes::PERIOD_INVALID,
        'period.in' => ErrorCodes::PERIOD_INVALID,
        'training_rhythm.required' => ErrorCodes::TRAINING_RHYTHM_REQUIRED,
        'training_rhythm.integer' => ErrorCodes::TRAINING_RHYTHM_INVALID,
        'training_rhythm.in' => ErrorCodes::TRAINING_RHYTHM_INVALID,
        'working_day.required' => ErrorCodes::WORKING_DAY_REQUIRED,
        'working_day.integer' => ErrorCodes::WORKING_DAY_INVALID,
        'working_day.in' => ErrorCodes::WORKING_DAY_INVALID,
        'token.required' => ErrorCodes::TOKEN_REQUIRED,
        'file.max' => ErrorCodes::FILE_TOO_LARGE,
        'file.required' => ErrorCodes::FILE_REQUIRED,
        'users.required' => ErrorCodes::USERS_REQUIRED,
        'users.array' => ErrorCodes::USERS_MUST_BE_ARRAY,
        'users.*.required' => ErrorCodes::USERS_CANT_BE_EMPTY,
        'users.*.integer' => ErrorCodes::USERS_MUST_CONTAIN_IDS,
        'users.*.exists' => ErrorCodes::USER_NOT_FOUND,
        'document.required' => ErrorCodes::DOCUMENT_REQUIRED,
        'document.integer' => ErrorCodes::DOCUMENT_MUST_BE_ID,
        'address.string' => ErrorCodes::ADDRESS_INVALID,
        'address_line_2.string' => ErrorCodes::ADDRESS_LINE_2_INVALID,
        'city.string' => ErrorCodes::CITY_INVALID,
        'postal_code.string' => ErrorCodes::POSTAL_CODE_INVALID,
        'country.string' => ErrorCodes::COUNTRY_INVALID,
        'additional_information.string' => ErrorCodes::ADDITIONAL_INFORMATION_INVALID,
        'relocation_range.numeric' => ErrorCodes::RELOCATION_RANGE_INVALID,
        'relocation_range.max' => ErrorCodes::RELOCATION_RANGE_TOO_LARGE,
        'relocation_long.numeric' => ErrorCodes::RELOCATION_LONG_INVALID,
        'relocation_lat.numeric' => ErrorCodes::RELOCATION_LAT_INVALID,
        'relocation_lat.required' => ErrorCodes::RELOCATION_LAT_INVALID,
        'is_billing.boolean' => ErrorCodes::IS_BILLING_INVALID,
        'google_place_id.required' => ErrorCodes::GOOGLE_PLACE_ID_REQUIRED,
        'google_place_id.string' => ErrorCodes::GOOGLE_PLACE_ID_INVALID,
        'formatted_address.required' => ErrorCodes::FORMATTED_ADDRESS_REQUIRED,
        'formatted_address.string' => ErrorCodes::FORMATTED_ADDRESS_INVALID,
        'long.required' => ErrorCodes::LONG_REQUIRED,
        'long.numeric' => ErrorCodes::LONG_INVALID,
        'lat.required' => ErrorCodes::LAT_REQUIRED,
        'lat.numeric' => ErrorCodes::LAT_INVALID,
        'add.array' => ErrorCodes::ADD_INVALID,
        'remove.array' => ErrorCodes::REMOVE_INVALID,
        'add.*' => ErrorCodes::ADD_INVALID,
        'remove.*' => ErrorCodes::REMOVE_INVALID,
        'add.*.exists' => ErrorCodes::NOT_FOUND,
        'remove.*.exists' => ErrorCodes::NOT_FOUND,
        'unit.string' => ErrorCodes::UNIT_INVALID,
        'current.numeric' => ErrorCodes::CURRENT_INVALID,
        'current.max' => ErrorCodes::CURRENT_TOO_LARGE,
        'goal.numeric' => ErrorCodes::GOAL_INVALID,
        'goal.max' => ErrorCodes::GOAL_TOO_LARGE,
        'initial.numeric' => ErrorCodes::INITIAL_INVALID,
        'initial.max' => ErrorCodes::INITIAL_TOO_LARGE,
        'target.in' => ErrorCodes::TARGET_INVALID,
        'start_at.required' => ErrorCodes::START_AT_REQUIRED,
        'start_at.integer' => ErrorCodes::START_AT_INVALID,
        'start_at.min' => ErrorCodes::START_AT_TOO_LOW,
        'end_at.required' => ErrorCodes::END_AT_REQUIRED,
        'end_at.integer' => ErrorCodes::END_AT_INVALID,
        'end_at.min' => ErrorCodes::END_AT_TOO_LOW,
        'availability.required' => ErrorCodes::AVAILABILITY_REQUIRED,
        'availability.integer' => ErrorCodes::AVAILABILITY_INVALID,
        'availability.*.integer' => ErrorCodes::AVAILABILITY_INVALID,
        'name.string' => ErrorCodes::NAME_INVALID,
        'description.string' => ErrorCodes::DESCRIPTION_INVALID,
        'availability.required' => ErrorCodes::AVAILABILITY_REQUIRED,
        'availability.integer' => ErrorCodes::AVAILABILITY_INVALID,
        'athlete.required' => ErrorCodes::ATHLETE_REQUIRED,
        'athlete.integer' => ErrorCodes::ATHLETE_INVALID,
        'name.string' => ErrorCodes::NAME_INVALID,
        'description.string' => ErrorCodes::DESCRIPTION_INVALID,
        'action.required' => ErrorCodes::ACTION_REQUIRED,
        'action.in' => ErrorCodes::ACTION_INVALID,
        'product.required' => ErrorCodes::PRODUCT_REQUIRED,
        'product.integer' => ErrorCodes::PRODUCT_INVALID,
        'product.exists' => ErrorCodes::PRODUCT_NOT_FOUND,
        'topic.string' => ErrorCodes::TOPIC_STRING,
        'topic.required' => ErrorCodes::TOPIC_REQUIRED,
        'problem.string' => ErrorCodes::PROBLEM_STRING,
        'problem.required' => ErrorCodes::PROBLEM_REQUIRED,
        'attachment.string' => ErrorCodes::ATTACHMENT_STRING,
        'bounded.boolean' => ErrorCodes::BOUNDED_INVALID,
        'social_reason.string' => ErrorCodes::SOCIAL_REASON_INVALID,
        'responsible_name.string' => ErrorCodes::RESPONSIBLE_NAME_INVALID,
        'activity.string' => ErrorCodes::ACTIVITY_INVALID,
        'participant_count.integer' => ErrorCodes::PARTICIPANT_COUNT_INVALID,
        'participant_count.in' => ErrorCodes::PARTICIPANT_COUNT_INVALID,
        'goal.integer' => ErrorCodes::GOAL_INVALID,
        'goal.exists' => ErrorCodes::NOT_FOUND,
        'access_code.required' => ErrorCodes::ACCESS_CODE_REQUIRED,
        'suggestion.required' => ErrorCodes::SUGGESTION_REQUIRED,
        'suggestion.exists' => ErrorCodes::NOT_FOUND,
        'physical_activity.required' => ErrorCodes::PHYSICAL_ACTIVITY_REQUIRED,
        'physical_activity.boolean' => ErrorCodes::PHYSICAL_ACTIVITY_INVALID,
        'medical_background.string' => ErrorCodes::MEDICAL_BACKGROUND_INVALID,
        'eating_routine.required' => ErrorCodes::EATING_ROUTINE_REQUIRED,
        'eating_routine.in' => ErrorCodes::EATING_ROUTINE_INVALID,
        'postal_code.required' => ErrorCodes::POSTAL_CODE_REQUIRED,
        'postal_code.string' => ErrorCodes::POSTAL_CODE_INVALID,
    ];
}