<?php
namespace MajorMedia\ToolBox\Utility;

class ErrorCodes
{
    public function __construct()
    {
        error_log('ErrorCodes class loaded');
    }
    // special error codes
    const UNEXPECTED = 1;
    const NOT_FOUND = 2;
    const FORBIDDEN = 3;

    // specific error codes

    // auth errors
    const REGISTRATION_DISABLED = 100000;
    const TOKEN_REFRESH_FAILED = 100001;
    const USER_AUTHENTICATION_FAILED = 100002;
    const AUTHENTICATION_ERROR = 100003;
    const BEARER_TOKEN_NOT_PROVIDED = 100004;

    // missing input errors
    const EMAIL_REQUIRED = 200000;
    const PASSWORD_REQUIRED = 200001;
    const ROLE_ID_REQUIRED = 200002;
    const USERNAME_REQUIRED = 200003;
    const NAME_REQUIRED = 200004;
    const SURNAME_REQUIRED = 200005;
    const BIRTHDAY_REQUIRED = 200006;
    const GENDER_REQUIRED = 200007;
    const LOGIN_REQUIRED = 200008;
    const OTP_REQUIRED = 200009;
    const USER_TYPE_REQUIRED = 200010;
    const CURRENT_PASSWORD_REQUIRED = 200011;
    const NEW_PASSWORD_REQUIRED = 200012;
    const PHONE_REQUIRED = 200013;
    const AGE_REQUIRED = 200014;
    const HEIGHT_REQUIRED = 200015;
    const WEIGHT_REQUIRED = 200016;
    const IS_SMOKER_REQUIRED = 200017;
    const ALCOHOL_CONSUMPTION_REQUIRED = 200018;
    const TIREDNESS_REQUIRED = 200019;
    const PHYSICAL_LEVEL_REQUIRED = 200020;
    const GOAL_REQUIRED = 200021;
    const PERIOD_REQUIRED = 200022;
    const TRAINING_RHYTHM_REQUIRED = 200023;
    const WORKING_DAY_REQUIRED = 200024;
    const TOKEN_REQUIRED = 200025;
    const FILE_REQUIRED = 200026;
    const USERS_REQUIRED = 200027;
    const DOCUMENT_REQUIRED = 200028;
    const GOOGLE_PLACE_ID_REQUIRED = 200029;
    const FORMATTED_ADDRESS_REQUIRED = 200030;
    const LONG_REQUIRED = 200031;
    const LAT_REQUIRED = 200032;
    const ADD_OR_REMOVE_REQUIRED = 200033;
    const START_AT_REQUIRED = 200034;
    const END_AT_REQUIRED = 200035;
    const AVAILABILITY_REQUIRED = 200036;
    const ATHLETE_REQUIRED = 200037;
    const ACTION_REQUIRED = 200038;
    const PRODUCT_REQUIRED = 200039;
    const TOPIC_REQUIRED = 200040;
    const PROBLEM_REQUIRED = 200041;
    const QR_REQUIRED = 200042;
    const ACCESS_CODE_REQUIRED = 200043;
    const SUGGESTION_REQUIRED = 200044;
    const PHYSICAL_ACTIVITY_REQUIRED = 200045;
    const EATING_ROUTINE_REQUIRED = 200046;
    const POSTAL_CODE_REQUIRED = 200047;
    const NO_GUIDE_FOUND = 200048;
    const NO_PRICE_FOR_THIS_NUMBER_PERSONS = 200049;
    const CIRCUIT_NOT_FOUND = 200050;

    // invalid input errors
    const EMAIL_INVALID = 300000;
    const PASSWORD_INVALID = 300001;
    const ROLE_ID_INVALID = 300002;
    const AVATAR_INVALID = 300003;
    const AVATAR_SIZE_EXCEEDED = 300004;
    const USERNAME_INVALID = 300005;
    const GENDER_INVALID = 300006;
    const OTP_INVALID = 300007;
    const OTP_TOO_SHORT = 300008;
    const OTP_TOO_LONG = 300009;
    const SURNAME_INVALID = 300010;
    const DESCRIPTION_INVALID = 300011;
    const NAME_INVALID = 300012;
    const PHONE_INVALID = 300013;
    const WEIGHT_INVALID = 300014;
    const WEIGHT_TOO_LOW = 300015;
    const HEIGHT_INVALID = 300016;
    const HEIGHT_TOO_LOW = 300017;
    const STATUS_INVALID = 300018;
    const SIREN_INVALID = 300019;
    const SIRET_INVALID = 300020;
    const TVA_INVALID = 300021;
    const SAP_INVALID = 300022;
    const MAIL_NOTIFICATIONS_INVALID = 300023;
    const BIRTHDAY_INVALID = 300024;
    const BIRTHDAY_TOO_HIGH = 300025;
    const BIRTHDAY_TOO_LOW = 300026;
    const PRO_CARD_EXPIRY_DATE_INVALID = 300027;
    const PRO_CARD_EXPIRY_DATE_TOO_LOW = 300028;
    const USER_TYPE_INVALID = 300029;
    const CURRENT_PASSWORD_INVALID = 300030;
    const NEW_PASSWORD_INVALID = 300031;
    const WORKING_DAY_TOO_LOW = 300032;
    const AGE_INVALID = 300033;
    const AGE_TOO_LOW = 300034;
    const AGE_TOO_HIGH = 300035;
    const IS_SMOKER_INVALID = 300036;
    const ALCOHOL_CONSUMPTION_INVALID = 300037;
    const ALCOHOL_CONSUMPTION_TOO_LOW = 300038;
    const TIREDNESS_INVALID = 300039;
    const TIREDNESS_TOO_LOW = 300040;
    const PHYSICAL_LEVEL_INVALID = 300041;
    const PHYSICAL_LEVEL_TOO_LOW = 300042;
    const GOAL_INVALID = 300043;
    const GOAL_TOO_LOW = 300044;
    const PERIOD_INVALID = 300045;
    const PERIOD_TOO_LOW = 300046;
    const TRAINING_RHYTHM_INVALID = 300047;
    const TRAINING_RHYTHM_TOO_LOW = 300048;
    const WORKING_DAY_INVALID = 300049;
    const SOCIAL_AUTH_TOKEN_INVALID = 300050;
    const TARGET_USER_INVALID = 300051;
    const TOKEN_INVALID = 300052;
    const FILE_MUST_BE_BASE64 = 300053;
    const FILE_TOO_LARGE = 300054;
    const USERS_MUST_BE_ARRAY = 300055;
    const USERS_CANT_BE_EMPTY = 300056;
    const USERS_MUST_CONTAIN_IDS = 300057;
    const DOCUMENT_MUST_BE_ID = 300058;
    const SELECT_CLIENTS_ONLY = 300059;
    const ADDRESS_INVALID = 300060;
    const ADDRESS_LINE_2_INVALID = 300061;
    const CITY_INVALID = 300062;
    const POSTAL_CODE_INVALID = 300063;
    const COUNTRY_INVALID = 300064;
    const ADDITIONAL_INFORMATION_INVALID = 300065;
    const RELOCATION_RANGE_INVALID = 300066;
    const RELOCATION_RANGE_TOO_LARGE = 300067;
    const IS_BILLING_INVALID = 300068;
    const GOOGLE_PLACE_ID_INVALID = 300069;
    const FORMATTED_ADDRESS_INVALID = 300070;
    const LONG_INVALID = 300071;
    const LAT_INVALID = 300072;
    const ADD_INVALID = 300073;
    const REMOVE_INVALID = 300074;
    const UNIT_INVALID = 300075;
    const CURRENT_INVALID = 300076;
    const CURRENT_TOO_LARGE = 300077;
    const GOAL_TOO_LARGE = 300078;
    const INITIAL_INVALID = 300079;
    const INITIAL_TOO_LARGE = 300080;
    const TARGET_INVALID = 300081;
    const START_AT_INVALID = 300082;
    const START_AT_TOO_LOW = 300083;
    const END_AT_INVALID = 300084;
    const END_AT_TOO_LOW = 300085;
    const TIMESTAMP_INVALID = 300086;
    const START_AT_FUTURE = 300087;
    const START_AT_AFTER_END_AT = 300088;
    const AVAILABILITY_RANGE_INVALID = 300089;
    const AVAILABILITY_LENGTH_TOO_LOW = 300090;
    const AVAILABILITY_INVALID = 300091;
    const ATHLETE_INVALID = 300092;
    const ACTION_INVALID = 300093;
    const PRODUCT_INVALID = 300094;
    const TOPIC_STRING = 300095;
    const PROBLEM_STRING = 300096;
    const ATTACHMENT_STRING = 300097;
    const HEIGHT_TOO_HIGH = 300098;
    const WEIGHT_TOO_HIGH = 300099;
    const INVALID_ACCOUNT_STATUS = 300100;
    const BOUNDED_INVALID = 300101;
    const FILTER_INTERVAL_TOO_BIG = 300102;
    const FROM_AFTER_TO = 300103;
    const RELOCATION_LONG_INVALID = 300105;
    const RELOCATION_LAT_INVALID = 300106;
    const SESSION_VERIFICATION_TOO_EARLY = 300107;
    const SESSION_VERIFICATION_TOO_LATE = 300108;
    const RESPONSIBLE_NAME_INVALID = 300109;
    const ACTIVITY_INVALID = 300110;
    const PARTICIPANT_COUNT_INVALID = 300111;
    const SOCIAL_REASON_INVALID = 300112;
    const INVALID_ACCESS_CODE = 300113;
    const START_AT_END_AT_SAME_DAY = 300114;
    const PHYSICAL_ACTIVITY_INVALID = 300115;
    const MEDICAL_BACKGROUND_INVALID = 300116;
    const EATING_ROUTINE_INVALID = 300117;
    const CIRCUIT_TYPE_INVALID = 300118;
    const TOKEN_BLACKLISTED = 300119;
    const PROJECT_TYPE_NOT_VALID = 300120;
    const SOCIAL_PLATFORM_NOT_VALID = 300121;

    // duplication errors
    const EMAIL_ALREADY_IN_USE = 400000;
    const USERNAME_ALREADY_IN_USE = 400001;
    const AVAILABILITY_ALREADY_EXISTS = 400002;
    const REQUEST_ALREADY_EXISTS = 400003;
    const REQUEST_ALREADY_ACCEPTED = 400004;
    const ACTIVE_SUBSCRIPTION_ALREADY_EXISTS = 400005;
    const SESSION_ALREADY_VERIFIED = 400006;
    const ATHLETE_ALREADY_HAS_COACH = 400007;
    const SUGGESTION_ALREADY_APPROVED = 400008;

    // data incorrect erros
    const INVALID_CREDENTIALS = 500000;
    const OTP_INCORRECT = 500001;
    const PASSWORD_INCORRECT = 500002;
    const TOKEN_INCORRECT = 500003;
    const DEVICE_TOKEN_INCORRECT = 500004;
    const QR_INCORRECT = 500005;
    const TOTAL_AMOUNT_MISMATCH = 500006;

    // expired erros
    const OTP_EXPIRED = 600000;
    const TOKEN_EXPIRED = 600001;
    const AVAILABILITY_EXPIRED = 600002;
    const REQUEST_EXPIRED = 600003;

    // confirmation erros
    const PASSWORD_CONFIRMATION_REQUIRED = 700000;
    const PASSWORD_CONFIRMATION_INVALID = 700001;
    const PASSWORD_CONFIRMATION_MISMATCH = 700002;
    const NEW_PASSWORD_CONFIRMATION_REQUIRED = 700003;
    const NEW_PASSWORD_CONFIRMATION_INVALID = 700004;
    const REVIEW_CREATED = 700005;
    const CIRCUIT_CREATED = 700006;
    const TRANSFERTS_CREATED = 700007;
    const REVIEW_DELETED = 700008;

    // not found errors
    const LOGIN_NOT_FOUND = 800000;
    const USER_NOT_FOUND = 800001;
    const DOCUMENT_NOT_FOUND = 800002;
    const PRODUCT_NOT_FOUND = 800003;



    const CART_UPDATED = 800004;
    const CART_FAILED = 80005;

    const CART_NOT_FOUND = 800006;
    const PRODUCT_NOT_FOUND_IN_CART = 800007;
    const PRODUCT_LIKE_SUCCESS = 800007;
    const PRODUCT_ALREADY_LIKED = 800008;
    const PRODUCT_UNLIKE_SUCCESS = 800009;
    const PRODUCT_NOT_LIKED = 8000010;
    const REVIEW_NOT_FOUND = 800002;
    const PROJECT_NOT_FOUND = 800003;
    const PAGE_NOT_FOUND = 800004;


    // other errors
    const CANT_ACCESS_RESOURCE = 900000;
    const AVAILABILITY_HAS_SESSION = 900001;
    const NO_ACTIVE_SUBSCRIPTION = 900002;
    const AVAILABILITY_NOT_ACTIVE = 900003;
    const REQUEST_REJECTED = 900004;
    const STRIPE_ERROR = 900005;
    const CANT_RENEW_SUBSCRIPTION = 900006;
    const MAX_SESSION_PER_WEEK_REACHED = 900007;
    const SUBSCRIPTION_NOT_SAFE = 900008;
    const CART_IS_EMPTY = 900009;
}