<?php if ($items): ?>
    <ul>
        <?php 
            $pluginCode = $pluginVector->pluginCodeObj->toCode();
            foreach ($items as $language):
                $dataId = 'localization-'.e($pluginCode).'-'.$language;
        ?>
            <li class="item" 
                data-id="<?= e($dataId) ?>" 
            >
                <a href="#" data-builder-command="localization:cmdOpenLanguage" data-plugin-code=<?= e($pluginCode) ?> data-id="<?= e($language) ?>">
                    <span class="title"><?= e($language) ?></span>
                    <span class="borders"></span>
                </a>
            </li>
        <?php endforeach ?>
    </ul>
<?php else: ?>
    <p class="no-data"><?= e(trans($this->noRecordsMessage)) ?></p>
<?php endif ?>